function AJD = scale_AJD(AJD, scalar, method)
% --------------------------------------------------------------------------------------------------
% Scale up the dynamics of a basic AJD with a multiplicative factor.
% --------------------------------------------------------------------------------------------------
% AJD       ... AJD object
% scalar    ... scalar to be applied to AJD dynamics
% --------------------------------------------------------------------------------------------------
% sample call: scale_AJD(struct('k', 0.01, 'theta', 0.01, 'sigma', 0.01, 'L', 0.01, 'mu', 0.01),  7.88)
% --------------------------------------------------------------------------------------------------

if (nargin < 3)
    method = 1;
end

% Rescale AJD dynamics
AJD.theta = AJD.theta * scalar;
AJD.sigma = AJD.sigma * sqrt(scalar);
if (method == 1)
    AJD.mu = AJD.mu * scalar;
else
    AJD.L = AJD.L * scalar;
end